/*
 * InputCaptureTextBrowser.cpp
 *
 *  Created on: 24.09.2014
 *      Author: stefan.detter
 */

#include "InputCaptureTextBrowser.h"


InputCaptureTextBrowser::InputCaptureTextBrowser(QWidget * parent)
	: QTextBrowser(parent)
{
	m_capturingActivated = false;
}

InputCaptureTextBrowser::~InputCaptureTextBrowser()
{

}

void InputCaptureTextBrowser::activateCapturing(bool on)
{
	m_capturingActivated = on;
}

void InputCaptureTextBrowser::keyPressEvent ( QKeyEvent * ev )
{
	if(m_capturingActivated)
		emit keyPressed(ev);
	else
		QTextBrowser::keyPressEvent(ev);
}

